package game;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Transparency;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;

import javax.imageio.ImageIO;
import javax.swing.JOptionPane;


public class CustomImageDataII {
	private BufferedImage myImage;
	private ImageObserver myObserver;
	private Color transColor;
	
	private int width;
	private int height;
	
	private String fileName;
	private boolean isResource;
	
	public static BufferedImage makeImageTransparent(BufferedImage rawImage, Color transparentColor) {
		
		if(transparentColor == null)
			return rawImage;
		
		Color transparent = new Color(0,0,0,0);
		int rgbTrans = transparent.getRGB();
		int rgbSrc = transparentColor.getRGB();
		
		for(int x = 0; x < rawImage.getWidth(); x++) {
			for(int y = 0; y < rawImage.getHeight(); y++) {
				if(rawImage.getRGB(x, y) == rgbSrc) {
					rawImage.setRGB(x, y, rgbTrans);
				}
			}
		}
		
		return rawImage;
	}
	
	private CustomImageDataII() {
		
	}
	
	public CustomImageDataII(BufferedImage theImage, int desiredWidth, int desiredHeight, Color transparentColor, ImageObserver obs, String theFilename, boolean shouldBeResource) {
		
		BufferedImage canvas = getGC().createCompatibleImage(desiredWidth, desiredHeight, Transparency.TRANSLUCENT);//Transparency.TRANSLUCENT
		Graphics g = canvas.getGraphics();
		g.drawImage(theImage, 0, 0, desiredWidth, desiredHeight, obs);
		g.dispose();
		
		myImage = makeImageTransparent(canvas, transparentColor);
		width = desiredWidth;
		height = desiredHeight;
		
		myObserver = obs;
		transColor = transparentColor;
		fileName = theFilename;
		isResource =shouldBeResource;
	}
	
	public CustomImageDataII(String imageName, Color transparentColor, ImageObserver io) {
		
		transColor = transparentColor;
		
		try {
			
			BufferedImage rawImage = ImageIO.read(CustomImageDataII.class.getResource(imageName));
			
			if(transparentColor != null) {
				rawImage = makeImageTransparent(rawImage, transparentColor);
			}
			
			myImage = getGC().createCompatibleImage(rawImage.getWidth(), rawImage.getHeight(), Transparency.TRANSLUCENT);//Transparency.TRANSLUCENT
			Graphics2D g = myImage.createGraphics();
			g.drawImage(rawImage, 0, 0, rawImage.getWidth(), rawImage.getHeight(), null, io);
			g.dispose();
			
			width = rawImage.getWidth();
			height = rawImage.getHeight();
			
			fileName = imageName;
			isResource = true;
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
//			System.err.println("Problem:  this image got an exception: <<" + imageName+ ">>");
//			e.printStackTrace();
		}
		
	}
	
	
	public CustomImageDataII(String imageName, Color transparentColor, ImageObserver io, int desiredWidth, int desiredHeight) {
		
		transColor = transparentColor;
		
		try {
			
			BufferedImage rawImage = ImageIO.read(CustomImageDataII.class.getResource(imageName));
			
			if(transparentColor != null) {
				rawImage = makeImageTransparent(rawImage, transparentColor);
			}
			
			myImage = getGC().createCompatibleImage(desiredWidth, desiredHeight, Transparency.TRANSLUCENT);//Transparency.TRANSLUCENT
			Graphics2D g = myImage.createGraphics();
			g.drawImage(rawImage, 0, 0, desiredWidth, desiredHeight, null, io);
			g.dispose();

			width = desiredWidth;
			height = desiredHeight;
			
			fileName = imageName;
			isResource = true;
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
//			System.err.println("exception; unable to load file/resource: <<" + imageName + ">>");
//			e.printStackTrace();
			JOptionPane.showMessageDialog(null, "Error occurred while trying to load image: \"" + imageName + "\".  Error message: " + e.getMessage(),"Error", JOptionPane.ERROR_MESSAGE);
		}
		
	}
	
	
	
	public CustomImageDataII(File imageFile, Color transparentColor, ImageObserver io) {
		
		transColor = transparentColor;
		
		if(imageFile.getName().equalsIgnoreCase("blank")) {
			fileName = imageFile.getName();
			return;
		}
		
		
		try {
			
			BufferedImage rawImage = ImageIO.read(imageFile);
			
			if(transparentColor != null) {
				rawImage = makeImageTransparent(rawImage, transparentColor);
			}
			
			myImage = getGC().createCompatibleImage(rawImage.getWidth(), rawImage.getHeight(), Transparency.TRANSLUCENT);//Transparency.TRANSLUCENT  //rawImage.getTransparency()
			Graphics2D g = myImage.createGraphics();
			g.drawImage(rawImage, 0, 0, rawImage.getWidth(), rawImage.getHeight(), io);
			g.dispose();

			width = rawImage.getWidth();
			height = rawImage.getHeight();
			
			fileName = imageFile.getAbsolutePath();
			isResource = false;
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
		}
		
	}
	
	public CustomImageDataII(File imageFile, Color transparentColor, ImageObserver io, int desiredWidth, int desiredHeight) {
		
		transColor = transparentColor;
		
		try {
			
			BufferedImage rawImage = ImageIO.read(imageFile);
			
			if(transparentColor != null) {
				rawImage = makeImageTransparent(rawImage, transparentColor);
			}
			
			myImage = getGC().createCompatibleImage(desiredWidth, desiredHeight, Transparency.TRANSLUCENT);//Transparency.TRANSLUCENT
			Graphics2D g = myImage.createGraphics();
			
//			AffineTransform at = new AffineTransform();
//			at.setToScale(((double) desiredWidth) / ((double) rawImage.getWidth()), ((double) desiredHeight) / ((double) rawImage.getHeight()));
			
//			g.drawImage(rawImage, at, io);
			g.drawImage(rawImage, 0, 0, desiredWidth, desiredHeight, null, io);
			g.dispose();
			
//			myImage = rawImage;

			width = desiredWidth;
			height = desiredHeight;
			
			fileName = imageFile.getAbsolutePath();
			isResource = false;
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
//			
//			System.out.println("Exception!  file is: " + imageFile.getAbsolutePath());
			
		}
		
	}
	
	public static BufferedImage createClone(BufferedImage orig, ImageObserver theObserver) {
		BufferedImage returnValue = null;
		
		returnValue = getGC().createCompatibleImage(orig.getWidth(theObserver), orig.getHeight(theObserver), orig.getTransparency());
		Graphics2D g = returnValue.createGraphics();
		g.drawImage(orig, 0, 0, null, theObserver);
		g.dispose();
		
		
		
		return returnValue;
	}
	
	
	public static BufferedImage createCloneNewDimensions(BufferedImage orig, ImageObserver theObserver, int newWidth, int newHeight) {
		BufferedImage returnValue = null;
		
		returnValue = getGC().createCompatibleImage(newWidth, newHeight, orig.getTransparency());
		Graphics2D g = returnValue.createGraphics();
		g.drawImage(orig, 0, 0, newWidth, newHeight, null, theObserver);
		g.dispose();
		
		
		
		return returnValue;
	}
	
	
	public CustomImageDataII createCloneThatIsMoreTransparent(int dividend, int divisor, boolean display) {
		
		int defaultAlphaComponent = 255 * dividend / divisor;
		
		CustomImageDataII returnValue = new CustomImageDataII();
		returnValue.myObserver = myObserver;
		returnValue.transColor = transColor;
		returnValue.width = width;
		returnValue.height = height;
		returnValue.isResource = isResource;
		returnValue.fileName = fileName;
		
		returnValue.myImage = getGC().createCompatibleImage(myImage.getWidth(myObserver), myImage.getHeight(myObserver), myImage.getTransparency());
		Graphics2D g = returnValue.myImage.createGraphics();
		g.drawImage(this.myImage, 0, 0, transColor, this.myObserver);
		g.dispose();
		
//		returnValue.myImage = makeImageTransparent(returnValue.myImage, returnValue.transColor);
		
//		Image tempImage = CustomImageData.makeImageMoreTransparentOfX(returnValue.myImage, dividend, divisor);
		
		
//		returnValue.myImage = getGC().createCompatibleImage(myImage.getWidth(myObserver), myImage.getHeight(myObserver), myImage.getTransparency());
//		g = returnValue.myImage.createGraphics();
//		g.drawImage(tempImage, 0, 0, this.myObserver);
//		g.dispose();
		
		Color srcCol = null;
		Color destCol = null;
		int srcColRGB;
		
		Color trans = new Color(0,0,0,0);
		int transRGB = trans.getRGB();
		
		for(int x = 0; x < returnValue.myImage.getWidth(myObserver); x++) {
			for(int y = 0; y < returnValue.myImage.getHeight(myObserver); y++) {
				
				srcColRGB = returnValue.myImage.getRGB(x, y);
				
				srcCol = new Color(srcColRGB);
				
//				if(display)
//					System.out.println("x" + x + ", y" + y + ", r" + srcCol.getRed() + ", g" + srcCol.getGreen() + ", b" + srcCol.getBlue() + ", a" + srcCol.getAlpha());
				
				if(srcCol.getRed() == returnValue.transColor.getRed() 
						&& srcCol.getGreen() == returnValue.transColor.getGreen()
						&& srcCol.getBlue() == returnValue.transColor.getBlue()) {
					returnValue.myImage.setRGB(x, y, transRGB);
					continue;
				} else {
					destCol = new Color(srcCol.getRed(), srcCol.getGreen(), srcCol.getBlue(), 255 * dividend / divisor);
//					destCol = new Color(0, 0, 255, srcCol.getAlpha() * dividend / divisor);
					returnValue.myImage.setRGB(x, y, destCol.getRGB());
				}
			}
		}
		
		return returnValue;
		
	}
	

	private static GraphicsConfiguration gc = null;
	
	public static synchronized GraphicsConfiguration getGC() {
		
		if(gc == null) {
			GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
			gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
		}
		
		return gc;
		
	}
	
	public BufferedImage getImage() {
		return myImage;
	}
	
	public int getDesiredWidth() {
		return width;
	}
	public int getDesiredHeight() {
		return height;
	}
	
	public void drawObject(Graphics g, int x, int y) {
		
		int desiredWidth = getDesiredWidth();
		int desiredHeight = getDesiredHeight();
		
		if(x - desiredWidth > PonyPanel.PLAY_AREA_WIDTH || x + desiredWidth < 0 
				|| y - desiredHeight > PonyPanel.PANEL_HEIGHT || y + desiredHeight < 0)
			return;
		
		
		int properXCoord = x - desiredWidth / 2;
		int properYCoord = y - desiredHeight / 2;
		
//		g.drawImage(myImage, properXCoord, properYCoord, width, height, myObserver);
		g.drawImage(myImage, properXCoord, properYCoord, myObserver);
		
	}
	
	
	public void drawObject(Graphics2D g, int x, int y) {
		
		int desiredWidth = getDesiredWidth();
		int desiredHeight = getDesiredHeight();
		
		if(x - desiredWidth > PonyPanel.PLAY_AREA_WIDTH || x + desiredWidth < 0 
				|| y - desiredHeight > PonyPanel.PANEL_HEIGHT || y + desiredHeight < 0)
			return;
		
		
		int properXCoord = x - desiredWidth / 2;
		int properYCoord = y - desiredHeight / 2;
		
//		g.drawImage(myImage, properXCoord, properYCoord, width, height, myObserver);
		g.drawImage(myImage, properXCoord, properYCoord, myObserver);
//		g.drawImage(myImage, null, properXCoord, properYCoord);
		
	}
	
	public void drawObjectIgnoreBounds(Graphics g, int x, int y) {
		
		int desiredWidth = getDesiredWidth();
		int desiredHeight = getDesiredHeight();
		
		
		int properXCoord = x - desiredWidth / 2;
		int properYCoord = y - desiredHeight / 2;
		
		g.drawImage(myImage, properXCoord, properYCoord, myObserver);
		
	}
	

	public void drawObjectFromUpperLeftCorner(Graphics g, int x, int y) {
		
//		if(myImage == null) {
//			System.out.println("myImage is null!");
//		}
		
		g.drawImage(myImage, x, y, myObserver);
		
		
	}
	
	public void setWidth(int newWidth) {
		width = newWidth;
	}
	
	public void setHeight(int newHeight) {
		height = newHeight;
	}
	
	public void setImage(BufferedImage newImage) {
		myImage = newImage;
	}
	
	
	public Color getTransparentColor() {
		return transColor;
	}
	
	public ImageObserver getObserver() {
		return myObserver;
	}

	public String getFileName() {
		return fileName;
	}

	public boolean isResource() {
		return isResource;
	}
	
	
	public static BufferedImage resizeImage(BufferedImage rawImage, int desiredWidth, int desiredHeight, ImageObserver io) {
		
		
		
		
		BufferedImage myImage = getGC().createCompatibleImage(desiredWidth, desiredHeight, Transparency.TRANSLUCENT);//Transparency.TRANSLUCENT
		Graphics2D g = myImage.createGraphics();
		g.drawImage(rawImage, 0, 0, desiredWidth, desiredHeight, null, io);
		g.dispose();
		
		return myImage;
	}
	
}
